
<?php
session_start();
require_once '../db_connect.php';

if (!isset($_SESSION['admin_logged_in'])) header("Location: index.php");

// ফাংশন: বর্তমান পিরিয়ড বের করা
function getNextPeriod($type) {
    $duration = 30; // 30 seconds default
    if($type == 'wingo1m') $duration = 60;
    if($type == 'wingo3m') $duration = 180;
    if($type == 'wingo5m') $duration = 300;
    
    $time = time();
    $current_period = floor($time / $duration);
    return date("Ymd") . ($current_period + 1); // Next Period
}

// রেজাল্ট সেট করার লজিক
if (isset($_POST['set_result'])) {
    $game_type = $_POST['game_type'];
    $number = $_POST['result_number'];
    $period = getNextPeriod($game_type);

    // কালার এবং সাইজ অটোমেটিক সেট হবে
    $color = ($number == 0 || $number == 5) ? 'Violet' : (($number % 2 == 0) ? 'Red' : 'Green');
    $size = ($number >= 5) ? 'Big' : 'Small';

    // আগের কোনো রেজাল্ট থাকলে ডিলিট করে নতুনটা বসানো
    $conn->query("DELETE FROM game_results WHERE game_type='$game_type' AND period='$period'");
    
    $stmt = $conn->prepare("INSERT INTO game_results (game_type, period, result_number, result_color, result_size) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("ssiss", $game_type, $period, $number, $color, $size);
    
    if ($stmt->execute()) {
        $msg = "Result Set for Next Period ($period): Number $number";
    } else {
        $error = "Failed to set result!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Game Control</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
    <style>
        .control-box { background: #1E2129; padding: 20px; border-radius: 10px; border: 1px solid #333; max-width: 500px; margin: 0 auto; }
        select, input { width: 100%; padding: 10px; margin: 10px 0; background: #000; color: #fff; border: 1px solid #444; border-radius: 5px; }
        .num-btn { width: 40px; height: 40px; border-radius: 50%; border: none; font-weight: bold; cursor: pointer; margin: 5px; color: white; }
        .bg-green { background: #28a745; }
        .bg-red { background: #dc3545; }
        .bg-violet { background: #9c27b0; }
        .selected-num { border: 3px solid #F5C300; transform: scale(1.1); }
        .submit-btn { width: 100%; padding: 12px; background: #F5C300; border: none; font-weight: bold; cursor: pointer; border-radius: 5px; margin-top: 15px; }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo">BOT CLUB ADMIN</div>
        <ul>
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="users.php"><i class="fas fa-users"></i> Users</a></li>
            <li><a href="deposits.php"><i class="fas fa-money-bill-wave"></i> Deposits</a></li>
            <li><a href="game_control.php" class="active"><i class="fas fa-gamepad"></i> Game Control</a></li>
            <li><a href="settings.php"><i class="fas fa-cogs"></i> Settings</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="header"><h2>Manual Game Control</h2></div>

        <div class="control-box">
            <?php if(isset($msg)) echo "<p style='color:green'>$msg</p>"; ?>
            <form method="POST">
                <label>Select Game Type:</label>
                <select name="game_type">
                    <option value="wingo30s">WinGo 30s</option>
                    <option value="wingo1m">WinGo 1 Min</option>
                    <option value="wingo3m">WinGo 3 Min</option>
                    <option value="wingo5m">WinGo 5 Min</option>
                </select>

                <label>Select Next Result Number:</label>
                <div style="text-align: center; margin: 15px 0;">
                    <button type="button" class="num-btn bg-violet" onclick="selectNum(0)">0</button>
                    <button type="button" class="num-btn bg-green" onclick="selectNum(1)">1</button>
                    <button type="button" class="num-btn bg-red" onclick="selectNum(2)">2</button>
                    <button type="button" class="num-btn bg-green" onclick="selectNum(3)">3</button>
                    <button type="button" class="num-btn bg-red" onclick="selectNum(4)">4</button>
                    <br>
                    <button type="button" class="num-btn bg-violet" onclick="selectNum(5)">5</button>
                    <button type="button" class="num-btn bg-red" onclick="selectNum(6)">6</button>
                    <button type="button" class="num-btn bg-green" onclick="selectNum(7)">7</button>
                    <button type="button" class="num-btn bg-red" onclick="selectNum(8)">8</button>
                    <button type="button" class="num-btn bg-green" onclick="selectNum(9)">9</button>
                </div>

                <input type="hidden" name="result_number" id="selected_number" required>
                <button type="submit" name="set_result" class="submit-btn">Set Result</button>
            </form>
        </div>
    </div>

    <script>
        function selectNum(num) {
            document.getElementById('selected_number').value = num;
            document.querySelectorAll('.num-btn').forEach(btn => btn.classList.remove('selected-num'));
            event.target.classList.add('selected-num');
        }
    </script>
</body>
</html>